local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");
local PulseLabel = THEME:GetMetric("Combo", "PulseLabelCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");
local LabelMinZoom = THEME:GetMetric("Combo", "LabelMinZoom");
local LabelMaxZoom = THEME:GetMetric("Combo", "LabelMaxZoom");

local t = Def.ActorFrame {
 	-- LoadActor(THEME:GetPathG("Combo","100Milestone")) .. {
	--	Name="OneHundredMilestone";
	--	FiftyMilestoneCommand=function(self) self:playcommand("Milestone") end;
	--};
	InitCommand=function(self) self:vertalign(bottom) end;
	LoadFont( "Combo", "number" ) .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadActor("_combo") .. {
		Name="Label";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
	LoadActor("_misses") .. {
		Name="LabelMisses";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
	InitCommand = function(self)
		-- We'll have to deal with this later
		--self:draworder(notefield_draw_order.over_field)
		c = self:GetChildren();
		c.Number:visible(false);
		c.Label:visible(false);
		c.LabelMisses:visible(false);
	end;
	-- Milestones:
	-- 25,50,100,250,600 Multiples;
--[[ 		if (iCombo % 100) == 0 then
			c.OneHundredMilestone:playcommand("Milestone");
		elseif (iCombo % 250) == 0 then
			-- It should really be 1000 but thats slightly unattainable, since
			-- combo doesnt save over now.
			c.OneThousandMilestone:playcommand("Milestone");
		else
			return
		end; --]]
	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:settext(""):visible(false);
			c.Label:visible(false);
			c.LabelMisses:visible(false);
			return;
		end

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		c.Number:visible(true);
		c.Label:visible(true);
		c.LabelMisses:visible(false);
		c.Number:settext( string.format("%i", iCombo) );
		-- FullCombo Rewards
		if param.FullComboW1 then
			c.Number:diffuse(color("#B2FBFF")):diffusebottomedge(color("#E5FEFF")):strokecolor(color("#0C656A"))
		elseif param.FullComboW2 then
			c.Number:diffuse(color("#FFFECD")):diffusebottomedge(color("#FFE4B4")):strokecolor(color("#6A4F0C"))
		elseif param.FullComboW3 then
			c.Number:diffuse(color("#FFFFFF")):diffusebottomedge(color("#AFFFE9")):strokecolor(color("#274A20"))
		elseif param.Combo then
			c.Number:diffuse(color("#F7F7F7")):diffusebottomedge(color("#B6B6B6")):strokecolor(color("#3B3B3B"))
		else
			c.Label:visible(false);
			c.LabelMisses:visible(true);
			c.Number:diffuse(color("#FFF6F6")):diffusebottomedge(color("#FFA7A9")):strokecolor(color("#AF3231"))
		end
		-- Pulse
		Pulse( c.Number, param );
		PulseLabel( c.Label, param );
		PulseLabel( c.LabelMisses, param );
		-- Milestone Logic
	end;
};

return t;
